// Copyright (C) 2014 to the present, Crestron Electronics, Inc.
// All rights reserved.
// No part of this software may be reproduced in any form, machine
// or natural, without the express written consent of Crestron Electronics.

/**
 *
 * \file        CresnetRconTimer.h
 *
 * \brief       Class that runs off timer and enqueues RCON packets into the console task
 *
 * \author      Adolfo Velasco
 *
 * \date        04/07/2014
 *
 */

#ifndef _CRESNET_RCON_TIMER_H_
#define _CRESNET_RCON_TIMER_H_

#include "dm_nutypedefs.h"

#define CRESNET_RCON_TIMER_PERIOD_MS         50

struct CresnetRconTimerEntry
{
    UINT8* pPacket;
};

class CresnetRconTimer
{
public:
    static void Create( UINT8 bBufferCount );
    static void Delete( void );

    static BOOL Add( UINT8* pPacket );

    static void Timer( void );
    static BOOL IsTimerCreated( void );

private:

    //Hide constructor/destructor to treat class as singleton
    CresnetRconTimer( UINT8 bBufferCount );
    ~CresnetRconTimer();
    static CresnetRconTimer* m_pTimer;

    BOOL AddPacket( UINT8* pPacket );
    UINT8 GetNextIndex( UINT8 bCurrentIndex );
    UINT8 GetPreviousIndex( UINT8 bCurrentIndex );
    UINT8* GetCurrentPacket( void );
    void IncrementRead( void );

    //Member variables
    UINT32 m_hTimer;
    UINT8 m_bWriteIndex;
    UINT8 m_bReadIndex;
    UINT8 m_bBufferCount;
    UINT32 m_hLock;
    CresnetRconTimerEntry* m_pPacketBuffer;
};

#endif  //_CRESNET_RCON_TIMER_H_
